using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;
using System.Web;

namespace VIRP.EFR.DAL
{
    public partial class STD_ANALYTE_TEST_REFERENCE_RANGEDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        private EFRDB2DataContext efrContext;

        public STD_ANALYTE_TEST_REFERENCE_RANGEDB()
        {
            efrContext = GetEfr2DataContext();
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public VIRP.EFR.BO.STD_ANALYTE_TEST_REFERENCE_RANGE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            VIRP.EFR.BO.STD_ANALYTE_TEST_REFERENCE_RANGE objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_ANALYTE_TEST_REFERENCE_RANGE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<VIRP.EFR.BO.STD_ANALYTE_TEST_REFERENCE_RANGE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<VIRP.EFR.BO.STD_ANALYTE_TEST_REFERENCE_RANGE> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_ANALYTE_TEST_REFERENCE_RANGE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VIRP.EFR.BO.STD_ANALYTE_TEST_REFERENCE_RANGE objSave)
        {
            Int32? objReturn = objSave.ID;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_STD_ANALYTE_TEST_REFERENCE_RANGE_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.REFERENCE_RANGE, objSave.STD_ANALYTE_TYPE_ID, objSave.STD_TEST_NAME_ID, objSave.STD_UNITS_ID, DateTime.Now, objSave.UPDATEDBY);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            Boolean objReturn = false;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_STD_ANALYTE_TEST_REFERENCE_RANGE_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        private IQueryable<STD_ANALYTE_TEST_REFERENCE_RANGE> LinqAll()
        {
            try
            {
                IQueryable<STD_ANALYTE_TEST_REFERENCE_RANGE> ReferenceRanges = (from e in efrContext.STD_ANALYTE_TEST_REFERENCE_RANGEs
                                                                                select e);
                //LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "", 0);

                return ReferenceRanges;
            }
            catch (Exception ex)
            {
                //LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "", 0);
                throw ex;
            }
        }

        public IEnumerable<ReferenceRangeView> SelectReferenceRanges()
        {
            return (from e in LinqAll()
                    select new ReferenceRangeView
                    {
                        ID = e.ID,
                        AnalyteName = e.STD_ANALYTETYPE.NAME,
                        TEFSCReferenceRange = e.REFERENCE_RANGE,
                        TestName = e.STD_TEST_NAME.NAME,
                        UnitID = e.STD_UNITS_ID,
                        UnitName = e.STD_UNIT.NAME
                    }).ToList();
        }

        public ReferenceRangeView SelectReferenceRangeByID(int ID)
        {
            using (EFRDBDataContext dbContext = GetEfrDataContext())
            {
                return (from e in SelectByIDLinqFilter(ID)

                        select new ReferenceRangeView
                        {
                            ID = e.ID,
                            AnalyteName = e.STD_ANALYTETYPE.NAME,
                            TEFSCReferenceRange = e.REFERENCE_RANGE,
                            TestName = e.STD_TEST_NAME.NAME,
                            UnitID = e.STD_UNITS_ID,
                            UnitName = e.STD_UNIT.NAME
                        }).FirstOrDefault();
            }
        }

        private IQueryable<STD_ANALYTE_TEST_REFERENCE_RANGE> SelectByIDLinqFilter(int ID)
        {
            return (from e in LinqAll()
                    where e.ID == ID
                    select e);
        }

        public class ReferenceRangeView
        {
            public int ID { get; set; }
            public string TestName { get; set; }
            public string AnalyteName { get; set; }
            public string TEFSCReferenceRange { get; set; }
            public int UnitID { get; set; }
            public string UnitName { get; set; }
        }

        public void UpdateReferenceRange(ReferenceRangeView RefRange)
        {
            STD_ANALYTE_TEST_REFERENCE_RANGE MyEntity = new STD_ANALYTE_TEST_REFERENCE_RANGE();

            MyEntity = (from e in efrContext.STD_ANALYTE_TEST_REFERENCE_RANGEs
                        where e.ID == RefRange.ID
                        select e).FirstOrDefault();

            MyEntity.REFERENCE_RANGE = RefRange.TEFSCReferenceRange;
            MyEntity.STD_UNITS_ID = RefRange.UnitID;
            MyEntity.UPDATED = DateTime.Now;
            MyEntity.UPDATEDBY = HttpContext.Current.User.Identity.Name;

            efrContext.SubmitChanges();
        }

        public VIRP.EFR.BO.STD_ANALYTE_TEST_REFERENCE_RANGE GetTestReferenceRange(int testId, int analyteId)
        {
            VIRP.EFR.BO.STD_ANALYTE_TEST_REFERENCE_RANGE objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objReturn = dbContext.usp_STD_ANALYTE_TEST_REFERENCE_RANGE_GetTestRefRange(testId, analyteId).FirstOrDefault();
                    LogManager.LogTiming(logDetails);

                    if (objReturn != null && objReturn.STD_UNITS_ID > 0)
                    {
                        STD_UNITSDB udb = new STD_UNITSDB();
                        objReturn.STD_UNIT = udb.GetItem(string.Empty, 0, objReturn.STD_UNITS_ID);
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
